#!/usr/bin/python
from lxml import etree as et
from copy import deepcopy
import sys
import os
import time

parser = et.XMLParser(remove_blank_text=True)

xmlfile = 'am50603_dxtw75w_es.xml'


props = ["Astro-2:Control-AstroEnable", "Astro-2:Control-AstroDimSubMode",
"Astro-2:Control-ResetOnTime","Astro-2:Control-ReloadFactory","Astro-2:NominalLevel",
"Astro-2:StartupFadeTime","Astro-2:AstroDIMFadeTime","Astro-2:SwitchOFFFadeTime",
"Astro-2:DimStartTime","Astro-2:DimLevel1","Astro-2:DimDuration1",
"Astro-2:DimLevel2","Astro-2:DimDuration2","Astro-2:DimLevel3",
"Astro-2:DimDuration3","Astro-2:DimLevel4","Astro-2:Latitude",
"Astro-2:Longitude","Astro-2:UTCTimeShift","Astro-2:EDonTime"
]

try:
    inp = et.parse(xmlfile, parser)

except et.XMLSyntaxError:
    print ("systax error found in file %s"%xmlfile)
    sys.exit(-1)

for prop in props:
    xmlProp = inp.find(f".//Property[@PgmName='{prop}']")
    if xmlProp != None:
        print(f"Found property {prop}")
        print(xmlProp[0][0].tag)
        if len(xmlProp[0]) > 1:
            print('skipping instance creation')
            continue
        tmp = deepcopy(xmlProp[0][0])
        xmlProp[0].append(tmp)
        xmlProp[0][0].set('Instance', '0')
        xmlProp[0][1].set('Instance', '1')
    else:
        print(f"Missing property {prop}")

inp.write('am50603_dxtw75w_esInst.xml', pretty_print=True, xml_declaration=True, encoding='utf-8')



        













