import flask
#import import_pf
from flask import request
from flask import Response
from flask import json
from lxml import etree as et
import sys
import os

import converter
import rawconverter
import err

app = flask.Flask(__name__)
app.config["DEBUG"] = False

VERSION = "unassigned"
try:
    with open("VERSION") as f:
        VERSION = f.readline()
except:
    pass

def extractApiKey(request):
    apikey = ""
    if 'X-API-KEY' in request.headers:
        apikey = request.headers['X-API-KEY']
    return apikey

@app.route('/ddf2ff/ping')
def hello_world():
    return "ddf2ff API version: "+ VERSION + "\n"

@app.route('/ddf2ff', methods=['POST'], defaults={'option': 'import'})
@app.route('/ddf2ff/<option>')
def ddf2ff(option):
    ddf = request.data
    option = request.args.get('option')
    if option is None:
        option = 'import'

    #baseurl = "localhost:5001"
    requrl = request.host_url.lower()
    print(requrl)

    # cloud environment handling (dev, test, staging, prod) is more complicated here
    # as the dd2fea service is called k8cluster internally (a different url as the t4t API url with the env information.)
    # but we need a url to forward dd store requests from the raw import.
    baseurl = "https://www.tuner4tronic.com"    # fallback if no Variant is set
    envVariant = os.getenv('VARIANT', "")
    if envVariant:
        baseurl =  f"http://{envVariant}-ddstore-back.{envVariant}-ddstore:5454"
    # in case of local debugging use the dev env from the cloud
    if requrl=="" or requrl.lower().find("localhost")>=0 or requrl.find("127.0.0.1")>=0:
        if requrl.find(":5005")>=0:
            baseurl = "http://localhost:5002"          # onprem url for the DDStore API
        else:
            baseurl = "http://dev.tuner4tronic.com"
    print(baseurl)
    app.logger.info(baseurl)
    (status, message, fea) = convert(ddf, option, baseurl, extractApiKey(request))

    if status != 200:
        response = app.response_class(
            response=json.dumps(message),
            status=status,
            mimetype='application/json'
        )
        # return Response(content=message, media_type="application/xml", status_code=status)
        return response
    else:
        response = app.response_class(
            response=fea,
            status=status,
            mimetype='application/json'
        )
        return response
        #return Response(content=fea, media_type="application/xml", status_code=status)

    # return "<h1>Distant Reading Archive</h1><p>This site is a prototype API for distant reading of science fiction novels.</p>"



def convert (inputbytes, option, baseurl, apikey):
    print("converting with option: " + option)
    if (inputbytes == None or inputbytes==b""):
        status = 422
        message="Import failed: no data received!"
        return (status, message, "")

    try:
        output = ""
        inputtree = converter.convert_bytes_to_xmltree(inputbytes)

        if option=="import":
            inputtree = converter.set_tree_to_default(inputtree)
            outputtree = converter.convert_ecgdescription_to_fea(inputtree)
            output  = et.tostring(outputtree, pretty_print=True, xml_declaration=True, encoding='utf-8')
            status  = 200
            message = "ok"

        elif option=="family":
            inputtree = converter.set_tree_to_default(inputtree)
            print("family step 1 complete")
            outputtree = converter.convert_forfamilyprogramming(inputtree) 
            print("family step 2 complete")
            output  = et.tostring(outputtree, pretty_print=True, xml_declaration=True, encoding='utf-8')
            print("family step 3 complete")
            status  = 200
            message = "ok"

        elif option=="raw":
            outputtree = rawconverter.convert_raw_2_project(inputtree, baseurl, apikey) 

            # outputtree.write(open("dalioutput.xml", 'bw'),
            #     pretty_print=True,
            #     xml_declaration=True,
            #     encoding='utf-8')

            outputtree = converter.convert_ecgdescription_to_fea(outputtree)

            output  = et.tostring(outputtree, pretty_print=True, xml_declaration=True, encoding='utf-8')
            status  = 200
            message = "ok"
        else:
            return (404, "Import failed: invalid option(s) received!", "")


    except err.InputError as e:
        message="Import failed due an error in the input file: " + format(e)
        return (400, message, "")


    except Exception as e:
        if hasattr(e, 'msg'):
            message="Import failed due to an internal error: " + e.msg
            return (500, message, "")
        else:
            message="Import failed due another internal error:" + format(e)
            return (500, message, "")


    return (status, message, output)

if __name__ == '__main__':
    if len(sys.argv) == 3:
        app.config['host'] = sys.argv[1]
        app.config['port'] = int(sys.argv[2])
    else:
        app.config['host'] = 'localhost'
        app.config['port'] = 5000

    print(app.config['port'])
    app.run(host=app.config['host'], port=app.config['port'])
    #app.run(port=5005)