#!/usr/bin/python
import os
import sys
import time
from converter import convert_bytes_to_xmltree, convert_ecgdescription_to_fea, set_tree_to_default


#fn = "am50603.xml"   # test with this file
fn = r"C:\Work\T4TWeb\alphaddfiles\ddfiles\AM52694.xml"

with open (fn, "rb") as fh:
    rawdata = fh.read()

xmldata = convert_bytes_to_xmltree(rawdata)

xmldata = set_tree_to_default(xmldata)

targetdata = convert_ecgdescription_to_fea(xmldata, filename=fn)

if targetdata != None:
    fn = fn[:-3]+"fea"  #  remove xml and add fea as extension
    targetdata.write(open(fn,"bw"), pretty_print=True, xml_declaration=True, encoding='utf-8')
else:
    print("error: did not get a feature file back")
