from lxml import etree as et
from copy import deepcopy

def getDisplayName(prop):
    dname = prop.find("./Display/Name/LangString")
    if (dname is not None):
        return dname.text
    return "no dname found"

def getUnit(prop):
    unit = prop.find("./Display/Unit/LangString")
    if (unit is not None):
        return unit.text
    return ""

def createFeaPropertyFromDDProperty(feature, subdevice, ddPropName, feaPropName) -> bool:
    """Creates a fea property from a ddfile property if it exists, returns True if the property is created"""
    ddProp = subdevice.find(f".//Property[@PgmName='{ddPropName}']")
    if ddProp is None:
        return False
    dname = getDisplayName(ddProp)
    unit = getUnit(ddProp)
    feaProp = et.Element("Property", Name=feaPropName, DName=dname, Map=ddPropName, Api="1", Unit=unit)
    if "PermW" in ddProp.attrib:
        feaProp.attrib["PermW"] = ddProp.attrib["PermW"]
    feaProp.append(deepcopy(ddProp.find("./Format")))
    feature.append(feaProp)
    return True

