###############################################################################
## 
##  Task:  Dumps a sorted list of property values (SetValue or if not found default value)
##
###############################################################################

import binascii
import struct
import logging
import os
import sys
import math

from lxml import etree as et


def get_structure_from_xml_file(fname):

    parser = et.XMLParser(remove_blank_text=True)
    if not os.path.exists(fname):
        print("File '%s' not found!"%fname)
        sys.exit(-1)
    try:
        data = et.parse(fname, parser)
    except et.XMLSyntaxError:
        num=len(parser.error_log)
        print("%d errors in %s found"%(num, fname))
        for i in range (num):
            error = parser.error_log[i]
            print("* ",error.message, " @line", error.line,"/column", error.column)
        sys.exit(0)
    return data

def printPropertyValues(sourcestructure):
    properties = sourcestructure.findall(".//Property")
    propertyValues = []
    for prop in properties:
        pname = prop.attrib["PgmName"]
        format = prop.find(".//Format")
        for sub in format:
            if "SetValue" in sub.attrib:
                value = sub.attrib["SetValue"]
            elif "Default" in sub.attrib:
                value = sub.attrib["Default"]
            else:
                value = "Value not found"
            propertyValues.append(f"{pname}: {value}")
    propertyValues.sort()
    for pvalue in propertyValues:
        print(pvalue)

sourcefilename = "LuminaireConfigurationV4.xml"   # static example
sourcestructure = get_structure_from_xml_file (sourcefilename)
printPropertyValues(sourcestructure)



