#!/usr/bin/python
from lxml import etree as et
from copy import deepcopy
import sys
import os
import time

parser = et.XMLParser(remove_blank_text=True)

xmlfile = 'am50603_dxtw75w_es.xml'

try:
    inp = et.parse(xmlfile, parser)

except et.XMLSyntaxError:
    print ("systax error found in file %s"%xmlfile)
    sys.exit(-1)

xmlProps = inp.findall(".//Property")
for prop in xmlProps:
    valInst = len(prop[0])
    allocInst = len(prop.findall(".//Allocation[@Interface='NFC']"))
    if valInst == 1 and allocInst == 2:
        print("Creating instance values for property:", prop.attrib["PgmName"], prop[0].tag) 
        tmp = deepcopy(prop[0][0])
        prop[0].append(tmp)
        prop[0][0].set('Instance', '0')
        prop[0][1].set('Instance', '1')
    #print(prop.attrib["PgmName"], valInst, allocInst)
        
inp.write('am50603_dxtw75w_esInst.xml', pretty_print=True, xml_declaration=True, encoding='utf-8')        
