import datetime
import math

# region external functions ###############################################################################################################

def DayOfYear (year: int, month: int, day: int):
    date = datetime.datetime.toordinal(datetime.date(year, month, day))
    dayone = datetime.datetime.toordinal(datetime.date(year, 1, 1))
    return date - dayone


def SunPosition (year: int, month: int,  day: int, hour: int, min: int, sec: int, lat: float, lon: float, timezone: float):
    num =  float(DayOfYear(year, 12, 31))
    num2 = float(DayOfYear(year, month, day))
    num3 = float(hour) + 0.016666666666666666 * float(min) + 0.00027777777777777778 * float(sec) - timezone + 1.0
    num3 = num3 - 4.0 * (15.0 - lon) / 60.0
    num2 = float(int(num2) * 360.0 / num + num3 / 24.0)
    grad = 0.3948 - 23.2559 * math.cos(math.radians(num2 + 9.1)) - 0.3915 * math.cos(math.radians(2.0 * num2 + 5.4)) - 0.1764 * math.cos(math.radians(3.0 * num2 + 26.0))
    num4 = 0.0066 + 7.3525 * math.cos(math.radians(num2 + 85.9)) + 9.9359 * math.cos(math.radians(2.0 * num2 + 108.9)) + 0.3387 * math.cos(math.radians(3.0 * num2 + 105.2))
    num5 = num3 + num4 / 60.0
    grad2 = (12.0 - num5) * 15.0
    num6 = math.cos(math.radians(grad2)) * math.cos(math.radians(lat)) * math.cos(math.radians(grad)) + math.sin(math.radians(lat)) * math.sin(math.radians(grad))
    num6 = 1.0 if (num6 > 1.0) else (-1.0 if (num6 < -1.0) else num6)
    num7 = math.degrees(math.asin(num6))
    num8 = (math.sin(math.radians(num7)) * math.sin(math.radians(lat)) - math.sin(math.radians(grad))) / (math.cos(math.radians(num7)) * math.cos(math.radians(lat)))
    num8 = 1.0 if (num8 > 1.0) else (-1.0 if (num8 < -1.0) else num8)
    num9 = math.degrees(math.acos(num8))

    if (num5 > 12.0 or num5 < 0.0):
        num9 = 180.0 + num9
    else:
        num9 = 180.0 - num9 

    return round(num7 * 1000.0, 0) / 1000.0


def SunRise(year: int, month: int, day: int, lat: float, lon: float, timezone: float) -> float:
    num  = 900.0
    num2 = 0.0 - num
    num3 = 86400.0

    while (True):
        num2 += num
        hour = int(num2 / 3600.0)
        min = int(num2 % 3600.0 / 60.0)
        sec = int(num2 % 60)
        if (SunPosition(year, month, day, hour, min, sec, lat, lon, timezone) > 0.0 or num2 > num3):
            break
    num2 -= num

    while (num > 1.0):
        num /= 2.0
        hour = int(num2 / 3600.0)
        min = int(num2 % 3600.0 / 60.0)
        sec = int(num2 % 60)
        if (SunPosition(year, month, day, hour, min, sec, lat, lon, timezone) > 0.0):
            num2 -= num
        else: 
            num2 += num
    return float(num2 / 3600.0)


def SunSet(year: int, month: int, day: int, lat: float, lon: float, timezone: float) -> float:
    num = 900.0
    num2 = 0.0
    num3 = 86400.0 + num

    while (True):
        num3 -= num
        hour = int(num3 / 3600.0)
        min = int(num3 % 3600.0 / 60.0)
        sec = int(num3 % 60)
        if (SunPosition(year, month, day, hour, min, sec, lat, lon, timezone) > 0.0 or num3 < num2):
           break
    
    num3 += num

    while (num > 1.0):
        num /= 2.0
        hour = int(num3 / 3600.0)
        min = int(num3 % 3600.0 / 60.0)
        sec = int(num3 % 60)
        if (SunPosition(year, month, day, hour, min, sec, lat, lon, timezone) > 0.0):
            num3 += num
        else:
            num3 -= num
    return num3 / 3600.0


def CalculateMidnightShift(latitude: float, longitude: float, timezone: float):
    sunset = 0.0
    sunrise = 0.0
    accumulatedShift = 0.0
    basedate = datetime.date(datetime.datetime.now().year, 1, 1)
    for i in range (366):
        
        day = basedate + datetime.timedelta(i)
        nextday = day + datetime.timedelta(1)
        sunset = SunSet(day.year, day.month, day.day, latitude, longitude, timezone)
        sunrise = SunRise(nextday.year, nextday.month, nextday.day, latitude, longitude, timezone)

        if (sunset != None and sunrise != None):
            nightLength = 24.0 + sunrise - sunset
            virtualMidnight = sunset + (nightLength / 2.0)
            midnightshift = virtualMidnight - 24.0
            accumulatedShift += midnightshift

    return int(round(accumulatedShift * 60 / 366, 0))

# endregion ext functions ###############################################################################################################
# region module tests ###############################################################################################################

def unsigned2signed_7byte(a):
    if a > 52: 
        return (128 - a) * -1
    else:
        return a

def unsigned2signed_word(a):
    if a > 32767: 
        return (65536 - a) * -1
    else:
        return a

def evaluate_all_predefined_locations():   # form the locations file as used in T4T
    import csv
    with open('locations.csv', newline='') as csvfile:
        locreader = csv.reader(csvfile, delimiter=';')
        next(locreader)                 # skip the header
        for row in locreader:   
            lat = float(unsigned2signed_word(int(row[1])))*0.125
            lon = float(unsigned2signed_word(int(row[2])))*0.125

            ts = float(unsigned2signed_7byte(int(row[3])))/4.0
            name = row[0]
            print(CalculateMidnightShift(lat, lon, ts), ";", row[5], ";", name)

    return

def main():
    # sunpos for a day in mid january in munich
    # for i in range(24):
    #     print(i, SunPosition (2020, 1,  16, i, 0, 0, 48.125, 11.625, 1.0))

    # print(SunRise(2020, 1, 16, 48.125, 11.625, 1.0)) # munich
    # print(SunSet(2020, 1, 16, 48.125, 11.625, 1.0))
    # print(CalculateMidnightShift(48.137, 11.5, 1.0))

    # print(SunRise(2020, 1, 16, 52.3667, 4.8945, 1.0)) # amsterdam
    # print(SunSet(2020, 1, 16, 52.375, 4.875, 1.0))
    # print(CalculateMidnightShift(52.375, 4.875, 1.0))

    # print(CalculateMidnightShift(39.875, 32.875, 2.0)) # ankara

    # compared to https://www.suncalc.org/

    evaluate_all_predefined_locations()

    return


if __name__ == "__main__":
    main()

# endregion #######################################################################################################################
